import WelcomeScreen from 'views/WelcomeScreen';
import UpdateDeviceScreen from 'views/UpdateDeviceScreen';
import UnsupportedUnitScreen from 'views/UnsupportedUnitScreen';
import DeviceNotRecognized from 'views/DeviceNotRecognized';
import ProblemUpdatingFirmwareScreen from 'views/ProblemUpdatingFirmwareScreen';
import UpdateDeviceCompleteScreen from 'views/UpdateDeviceCompleteScreen';
import NotLoggedInScreen from 'views/NotLoggedInScreen';
import USBErrorScreen from 'views/USBErrorScreen';

const routes = {
    NOT_LOGGED_IN: { path: '/', component: NotLoggedInScreen },
    WELCOME: { path: '/welcome', component: WelcomeScreen },
    UPDATE_DEVICE: { path: '/updateDevice', component: UpdateDeviceScreen },
    UNSUPPORTED_UNIT: {
        path: '/unsupportedUnit',
        component: UnsupportedUnitScreen
    },
    USB_ERROR_UNIT: {
        path: '/usbError',
        component: USBErrorScreen
    },
    PROBLEM_UPDATING_FIRMWARE: {
        path: '/problemUpdatingFirmwareScreen',
        component: ProblemUpdatingFirmwareScreen
    },
    DEVICE_NOT_RECOGNIZED: {
        path: '/deviceNotRecognized',
        component: DeviceNotRecognized
    },
    UPDATE_DEVICE_DONE: {
        path: '/updateDeviceCompleteScreen',
        component: UpdateDeviceCompleteScreen
    }
};

export default routes;
